# Declare configuration
ASTUS_CONFIG = {
    "XL": {
        "version": "XL",
        "cols": 6,
        "rows": 14,
        "depths": 1,
        "col_types": [
            "1/3", "1/3", "1/3",
            "1/3", "1/3", "1/3"
        ],
        "row_types": [
            "B", "B", "B", "B", "B", "B",
            "H", "H", "H", "H", "H", "H", "H", "H"
        ],
        "prefix_tray": "PIL",
        "blacklist": [(0, 5), (1, 5), (2, 5), (3, 5), (4, 5), (5, 5), (6, 5)]
    },
    "V6": {
        "version": "6",
        "cols": 6,
        "rows": 23,
        "depths": 2,
        "col_types": [
            "1/3", "1/3", "1/3",
            "1/3", "1/3", "1/3"
        ],
        "row_types": [
            "B", "B", "B", "B", "B", "B", "B", "B", "B", "H",
            "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"
        ],
        "prefix_tray": "BAC",
        "blacklist": [
            (0, 5), (1, 5), (2, 5), (3, 5), (4, 5),
            (5, 5), (6, 5), (7, 5), (8, 5), (9, 5),
            (10, 5)
        ]
    },
    "V7": {
        "version": "7",
        "cols": 7,
        "rows": 23,
        "depths": 2,
        "col_types": [
            "1/7", "1/7",
            "1/3", "1/3", "1/3", "1/3", "1/3"
        ],
        "row_types": [
            "B", "B", "B", "B", "B", "B", "B", "B", "B", "H",
            "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"
        ],
        "prefix_tray": "BAC",
        "blacklist": [
            (0, 6), (1, 6), (2, 6), (3, 6), (4, 6),
            (5, 6), (6, 6), (7, 6), (8, 6), (9, 6),
            (10, 6)
        ]
    },
    "V8": {
        "version": "8",
        "cols": 8,
        "rows": 23,
        "depths": 2,
        "col_types": [
            "1/7", "1/7", "1/7", "1/7",
            "1/3", "1/3", "1/3", "1/3"
        ],
        "row_types": [
            "B", "B", "B", "B", "B", "B", "B", "B", "B", "H",
            "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"
        ],
        "prefix_tray": "BAC",
        "blacklist": [
            (0, 7), (1, 7), (2, 7), (3, 7), (4, 7),
            (5, 7), (6, 7), (7, 7), (8, 7), (9, 7),
            (10, 7)
        ]
    },
    "V9": {
        "version": "9",
        "cols": 9,
        "rows": 23,
        "depths": 2,
        "col_types": [
            "1/7", "1/7", "1/7", "1/7", "1/7",
            "1/7", "1/3", "1/3", "1/3"
        ],
        "row_types": [
            "B", "B", "B", "B", "B", "B", "B", "B", "B", "H",
            "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"
        ],
        "prefix_tray": "BAC",
        "blacklist": [
            (0, 8), (1, 8), (2, 8), (3, 8), (4, 8),
            (5, 8), (6, 8), (7, 8), (8, 8), (9, 8),
            (10, 8)
        ]
    },
    "V10": {
        "version": "10",
        "cols": 10,
        "rows": 23,
        "depths": 2,
        "col_types": [
            "1/7", "1/7", "1/7", "1/7", "1/7",
            "1/7", "1/7", "1/7", "1/3", "1/3"
        ],
        "row_types": [
            "B", "B", "B", "B", "B", "B", "B", "B", "B", "H",
            "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"
        ],
        "prefix_tray": "BAC",
        "blacklist": [
            (0, 9), (1, 9), (2, 9), (3, 9), (4, 9),
            (5, 9), (6, 9), (7, 9), (8, 9), (9, 9),
            (10, 9)
        ]
    },
    "V11": {
        "version": "11",
        "cols": 11,
        "rows": 23,
        "depths": 2,
        "col_types": [
            "1/7", "1/7", "1/7", "1/7", "1/7", "1/7",
            "1/7", "1/7", "1/7", "1/7", "1/3"
        ],
        "row_types": [
            "B", "B", "B", "B", "B", "B", "B", "B", "B", "H",
            "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"
        ],
        "prefix_tray": "BAC",
        "blacklist": [
            (0, 10), (1, 10), (2, 10), (3, 10), (4, 10),
            (5, 10), (6, 10), (7, 10), (8, 10), (9, 10),
            (10, 10)
        ]
    }
}
