from peewee import AutoField, CharField, DateTimeField
from peewee import SQL

from ..base import BaseModel


class Sejour(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    ipp = CharField(
        column_name='x_num_ipp', constraints=[SQL("DEFAULT ''")])
    sejour = CharField(
        column_name='x_num_sej', constraints=[SQL("DEFAULT ''")])
    date_entree = DateTimeField(
        column_name='x_tentree',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    uf_hosp = CharField(
        column_name='x_uf_hosp', constraints=[SQL("DEFAULT ''")])
    uf_alit = CharField(
        column_name='x_uf_alit', constraints=[SQL("DEFAULT ''")])
    date_sortie = DateTimeField(
        column_name='x_tsortie', null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    chambre = CharField(
        column_name='x_chambre', constraints=[SQL("DEFAULT ''")])
    lit = CharField(
        column_name='x_lit', constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_sejour'
