from datetime import datetime

from peewee import AutoField, DateTimeField, SQL, CharField, TextField, BooleanField, IntegerField

from median.base import BaseModel


class WsclientError(BaseModel):
    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono',
        constraints=[SQL("DEFAULT 'CURRENT_TIMESTAMP'")], default=datetime.now)
    url = CharField(
        column_name='x_url', max_length=50, constraints=[SQL("DEFAULT ''")]
    )
    wsdl = CharField(
        column_name='x_wsdl', max_length=50, constraints=[SQL("DEFAULT ''")]
    )
    function = CharField(
        column_name='x_fonction', max_length=50, constraints=[SQL("DEFAULT ''")]
    )
    param = TextField(
        column_name='x_param',  constraints=[SQL("DEFAULT ''")]
    )
    error_msg = TextField(
        column_name='x_msg_erreur',  constraints=[SQL("DEFAULT ''")]
    )
    is_delete = BooleanField(column_name='x_supp',  default=False)
    nb_retry = IntegerField(column_name='x_nb_retry',  default=False)
    poste = CharField(
        column_name='x_poste', max_length=20, constraints=[SQL("DEFAULT ''")])
    username = CharField(
        column_name='x_user', max_length=60, constraints=[SQL("DEFAULT ''")])
    retry_date = DateTimeField(
        column_name='x_dtretry',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])

    class Meta:
        table_name = 'f_wsclient_erreur'
        indexes = (
            (('x_chrono',), False),
            (('x_fonction',), False),
            (('x_supp',), False),
        )
