from peewee import fn
from median.models import Magasin, Stock, Patient, Sejour, Prescription, Product, ListeModel, ListeItemModel, Seuil
from median.constant import EtatListe, PatientGlobal, TypeListe, TypeServiListe
from median.utils import date_add_month
from random import randint
import time
import datetime
import random

moments = ["matin", "midi", "soir", "coucher"]
moments_hours = {"matin": 6, "midi": 11, "soir": 17, "coucher": 20}
moments_alveole = {"matin": 1, "midi": 2, "soir": 3, "coucher": 4}


def demo_riedl(clean=False):
    """Generate demo datas"""
    if clean:
        lsts = ListeModel.select(ListeModel).where(
            ListeModel.mode == TypeListe.Output.value, ListeModel.zone_deb == "RIEDL"
        )
        for li in lsts:
            li.delete_instance()
        return

    mags = Magasin().select(Magasin).where(Magasin.eco_type == "L")
    for m in mags:
        for i in range(2):
            nb_items = 0
            ul01 = ListeModel()
            ul01.liste = "%s-DEMO-%s-%i" % (m.mag, time.strftime("%Y%m%d-%H%M%S"), i)
            ul01.service = "DEENOVA"
            ul01.type_servi = TypeServiListe.RiedlBoite.value
            ul01.mode = TypeListe.Output.value
            ul01.etat = EtatListe.Vierge.value
            ul01.fusion = "TEST_PYTHON"
            ul01.zone_deb = "RIEDL"
            ul01.zone_fin = m.type_mag
            ul01.num_ipp = PatientGlobal.Ipp.value
            ul01.num_sej = PatientGlobal.Sejour.value
            ul01.no_pilulier = 2
            ul01.selectionne = 0
            ul01.valide_sel = 0
            ul01.pos_pilulier = 1
            ul01.save()

            for j in range(1, randint(5, 10)):
                # randint(5, 123)

                stkRnd = Stock.select(Stock).where(Stock.magasin == m.mag).order_by(fn.Rand())
                one_stock = stkRnd.get()
                nb_items = nb_items + 1
                it01 = ListeItemModel()
                it01.liste = ul01.liste
                it01.mode = ul01.mode
                it01.etat = EtatListe.Vierge.value
                it01.reference = one_stock.reference
                it01.item = "%06d" % j
                it01.qte_dem = randint(5, 123)
                it01.qte_serv = 0
                it01.lot = ""
                it01.info = ""
                it01.dest = ul01.service
                it01.save()

            ul01.nb_item = nb_items
            ul01.save()


def demo_riedl_storage(clean=False):
    if clean:
        lsts = ListeModel.select(ListeModel).where(
            ListeModel.mode == TypeListe.Input.value,
            ListeModel.type_servi == TypeServiListe.GlobaleBoite.value,
            ListeModel.zone_deb == "RIEDL",
        )
        for li in lsts:
            li.delete_instance()
        return

    mags = Magasin().select(Magasin).where(Magasin.eco_type == "L")
    for m in mags:
        for i in range(2):
            nb_items = 0
            ul01 = ListeModel()
            ul01.liste = "%s-RANGEMENT-%s-%i" % (m.mag, time.strftime("%Y%m%d-%H%M%S"), i)
            ul01.service = "TRAN"
            ul01.type_servi = TypeServiListe.GlobaleBoite.value
            ul01.mode = TypeListe.Input.value
            ul01.etat = EtatListe.Vierge.value
            ul01.fusion = "RANGEMENT"
            ul01.zone_deb = "RIEDL"
            ul01.zone_fin = m.type_mag
            ul01.num_ipp = PatientGlobal.Ipp.value
            ul01.num_sej = PatientGlobal.Sejour.value
            ul01.no_pilulier = 1
            ul01.selectionne = 0
            ul01.valide_sel = 0
            ul01.pos_pilulier = 1
            ul01.save()

            for j in range(1, randint(2, 5)):
                # randint(5, 123)

                # stkRnd = Stock.select(Stock).where(Stock.magasin == m.mag).order_by(fn.Rand())
                proRnd = Product.select(Product).where(Product.reference != "").order_by(fn.Rand())
                # one_stock = stkRnd.get()
                one_stock = proRnd.get()
                nb_items = nb_items + 1
                it01 = ListeItemModel()
                it01.liste = ul01.liste
                it01.mode = ul01.mode
                it01.etat = EtatListe.Vierge.value
                it01.reference = one_stock.reference
                it01.item = "%06d" % j
                it01.qte_dem = randint(5, 123)
                it01.qte_serv = 0
                it01.lot = ""
                it01.info = ""
                it01.dest = ul01.service
                it01.save()

            ul01.nb_item = nb_items
            ul01.save()


def demo_riedl_taking_mode(clean=False):
    if clean:
        lsts = ListeModel.select(ListeModel).where(
            ListeModel.mode == TypeListe.Input.value,
            ListeModel.type_servi == TypeServiListe.Prelevement.value,
            ListeModel.zone_deb == "RIEDL",
        )
        for li in lsts:
            li.delete_instance()
        return


def date_plus_heure():
    return ""


def date_heure_texte(heure):
    return "%04i" % (heure * 100)


def demo_acced_nominatif(clean=False):
    if clean:
        print("ACCED Nominative cleanup")
        lsts = ListeModel.select(ListeModel).where(
            ListeModel.mode == TypeListe.Output.value, ListeModel.type_servi == "NOMINATIF"
        )
        for li in lsts:
            li.delete_instance()
        return

    print("Generate datas for Nominative")
    current_day = datetime.datetime.now()
    mags = Magasin().select(Magasin).where(Magasin.eco_type == "C")
    for m in mags:
        print(" -> ACCED %s" % m.mag)
        pat, created = Patient.get_or_create(
            ipp="%s%03i" % (time.strftime("%Y%m%d%H%M"), m.pk),
            defaults={
                "nom": "Nom",
                "prenom": "Prénom %s" % time.strftime("%Y%m%d"),
                "date_naissance": datetime.datetime.now(),
                "date_maj": datetime.datetime.now(),
                "sexe": "H",
            },
        )
        sej, created = Sejour.get_or_create(
            ipp=pat.ipp,
            sejour=pat.ipp,
            defaults={
                "date_entree": datetime.datetime.now(),
                "uf_hosp": "DEENOVA",
                "uf_alit": "DEENOVA",
                "chambre": "10",
                "lit": "P",
            },
        )

        # Ajout d'une prescription

        pc01, created = Prescription.get_or_create(
            ipp=pat.ipp,
            sejour=sej.sejour,
            defaults={
                "ordre": "%s" % (time.strftime("%Y%m%d-%H%M%S"),),
                "nom": pat.nom,
                "prenom": pat.prenom,
                "date_naissance": pat.date_naissance,
                "sexe": pat.sexe,
                "chambre": sej.chambre,
                "lit": sej.lit,
            },
        )

        for i in range(7):
            nb_items = 0

            ul01 = ListeModel()
            ul01.liste = "%s-%s-%s" % (m.mag, current_day.strftime("%Y-%m-%d"), sej.sejour)
            ul01.service = "DEENOVA"
            ul01.type_servi = TypeServiListe.Nominatif.value
            ul01.mode = TypeListe.Output.value
            ul01.etat = EtatListe.Vierge.value
            ul01.fusion = "DEENOVA - DEENOVA"
            ul01.ddeb = current_day
            ul01.zone_deb = ""
            ul01.zone_fin = ""
            ul01.num_ipp = pat.ipp
            ul01.ipp = pat.ipp
            ul01.num_sej = sej.sejour
            ul01.no_pilulier = 2
            ul01.selectionne = 0
            ul01.valide_sel = 0
            ul01.pos_pilulier = 1
            ul01.id_prescription = pc01.pk
            ul01.liste_pat = "%s-%s-%s" % (m.mag, sej.sejour, current_day.strftime("%Y%m%d"))
            ul01.save()

            item_readonly = 0
            for j in range(1, randint(5, 12)):
                # randint(5, 123)
                mom = random.choice(moments)
                stkRnd = Stock.select(Stock).where(Stock.magasin == m.mag).order_by(fn.Rand())
                if stkRnd.count() > 0:
                    one_stock = stkRnd.get()
                    nb_items = nb_items + 1
                    it01 = ListeItemModel()
                    it01.liste = ul01.liste
                    it01.mode = ul01.mode
                    it01.etat = EtatListe.Vierge.value
                    it01.reference = one_stock.reference
                    it01.item = "%06d" % j
                    it01.qte_dem = randint(1, 11)
                    it01.qte_serv = 0
                    it01.num_ipp = pat.ipp
                    it01.num_sej = sej.sejour
                    it01.dest = ul01.service
                    it01.moment = mom
                    it01.heure = date_heure_texte(moments_hours[mom])
                    it01.dtprise = current_day.strftime("%Y%m%d")
                    it01.alveole_theo = moments_alveole[mom]
                    it01.type_servi = ul01.type_servi
                    it01.lot = ""
                    it01.info = sej.sejour
                    it01.id_presc = pc01.pk
                    it01.liste_pat = ul01.liste_pat
                    it01.qte_prescrite = it01.qte_dem
                    it01.readonly = item_readonly
                    it01.save()

                    if j in [1, 5, 10, 11, 13, 15, 19]:
                        item_readonly = 1
                    else:
                        item_readonly = 0

            ul01.nb_item = nb_items
            ul01.save()
            current_day = current_day + datetime.timedelta(days=1)


def demo_acced_globale(clean=False):
    if clean:
        print("ACCED Globale cleanup")
        lsts = ListeModel.select(ListeModel).where(
            ListeModel.mode == TypeListe.Output.value,
            ListeModel.zone_deb == "",
            ListeModel.zone_fin == "",
            ListeModel.type_servi == "GLOBAL_BTE",
        )
        for li in lsts:
            li.delete_instance()

        return

    current_day = datetime.datetime.now()
    print("Generate datas for Globale")
    mags = Magasin().select(Magasin).where(Magasin.eco_type == "C")
    for m in mags:
        print(" -> ACCED %s" % m.mag)
        for i in range(2):
            nb_items = 0

            ul01 = ListeModel()
            ul01.liste = "%s-%s-%s" % (m.mag, current_day.strftime("%Y-%m-%d"), "GLOBAL%i" % i)
            ul01.service = "DEENOVA"
            ul01.type_servi = TypeServiListe.GlobaleBoite.value
            ul01.mode = TypeListe.Output.value
            ul01.etat = EtatListe.Vierge.value
            ul01.fusion = "GLOBALE - BOITE"
            ul01.ddeb = current_day
            ul01.zone_deb = ""
            ul01.zone_fin = ""
            ul01.num_ipp = PatientGlobal.Ipp.value
            ul01.ipp = PatientGlobal.Ipp.value
            ul01.num_sej = PatientGlobal.Sejour.value
            ul01.no_pilulier = 2
            ul01.selectionne = 0
            ul01.valide_sel = 0
            ul01.pos_pilulier = 1
            ul01.id_prescription = 0
            ul01.liste_pat = "%s-%s-%s" % (m.mag, "GLOBAL", current_day.strftime("%Y%m%d"))
            ul01.save()

            for j in range(1, randint(2, 7)):
                # randint(5, 123)
                # mom = random.choice(moments)
                stkRnd = Stock.select(Stock).where(Stock.magasin == m.mag).order_by(fn.Rand())

                if stkRnd.count() > 0:
                    one_stock = stkRnd.get()
                    nb_items = nb_items + 1
                    it01 = ListeItemModel()
                    it01.liste = ul01.liste
                    it01.mode = ul01.mode
                    it01.etat = EtatListe.Vierge.value
                    it01.reference = one_stock.reference
                    it01.item = "%06d" % j
                    it01.qte_dem = randint(5, 123)
                    it01.qte_serv = 0
                    it01.num_ipp = ul01.num_ipp
                    it01.num_sej = ul01.num_sej
                    it01.dest = ul01.service
                    it01.moment = "matin"
                    it01.heure = 6
                    it01.dtprise = current_day.strftime("%Y%m%d")
                    it01.alveole_theo = 1
                    it01.type_servi = ul01.type_servi
                    it01.lot = ""
                    it01.info = ""
                    it01.id_presc = 0
                    it01.liste_pat = ul01.liste_pat
                    it01.qte_prescrite = it01.qte_dem
                    it01.readonly = 0
                    it01.save()

            ul01.nb_item = nb_items
            ul01.save()


def demo_astus_nominatif(clean=False):
    if clean:
        print("ASTUS Nominative cleanup")
        lsts = ListeModel.select(ListeModel).where(
            ListeModel.mode == TypeListe.Output.value, ListeModel.type_servi == TypeServiListe.Exotique.value
        )
        for li in lsts:
            li.delete_instance()
        return

    print("ASTUS Generate datas for Nominative")
    current_day = datetime.datetime.now()
    mags = Magasin().select(Magasin).where(Magasin.eco_type == "A")
    for m in mags:
        print(" -> ASTUS %s" % m.mag)
        pat, created = Patient.get_or_create(
            ipp="%s%03i" % (time.strftime("%Y%m%d%H%M"), m.pk),
            defaults={
                "nom": "Nom",
                "prenom": "Prénom %s" % time.strftime("%Y%m%d"),
                "date_naissance": datetime.datetime.now(),
                "date_maj": datetime.datetime.now(),
                "sexe": "H",
            },
        )
        sej, created = Sejour.get_or_create(
            ipp=pat.ipp,
            sejour=pat.ipp,
            defaults={
                "date_entree": datetime.datetime.now(),
                "uf_hosp": "DEENOVA",
                "uf_alit": "DEENOVA",
                "chambre": "10",
                "lit": "P",
            },
        )

        # Ajout d'une prescription

        pc01, created = Prescription.get_or_create(
            ipp=pat.ipp,
            sejour=sej.sejour,
            defaults={
                "ordre": "%s" % (time.strftime("%Y%m%d-%H%M%S"),),
                "nom": pat.nom,
                "prenom": pat.prenom,
                "date_naissance": pat.date_naissance,
                "sexe": pat.sexe,
                "chambre": sej.chambre,
                "lit": sej.lit,
            },
        )

        for i in range(7):
            nb_items = 0

            ul01 = ListeModel()
            ul01.liste = "%s-%s-%s" % (m.mag, current_day.strftime("%Y-%m-%d"), sej.sejour)
            ul01.service = "DEENOVA"
            ul01.type_servi = TypeServiListe.Exotique.value
            ul01.mode = TypeListe.Output.value
            ul01.etat = EtatListe.Vierge.value
            ul01.fusion = "ASTUS - DEENOVA"
            ul01.ddeb = current_day
            ul01.zone_deb = "ASTUS"
            ul01.zone_fin = ""
            ul01.num_ipp = pat.ipp
            ul01.ipp = pat.ipp
            ul01.num_sej = sej.sejour
            ul01.no_pilulier = 2
            ul01.selectionne = 0
            ul01.valide_sel = 0
            ul01.pos_pilulier = 1
            ul01.id_prescription = pc01.pk
            ul01.liste_pat = "%s-%s-%s" % (m.mag, sej.sejour, current_day.strftime("%Y%m%d"))
            ul01.save()

            item_readonly = 0
            for j in range(1, randint(5, 12)):
                # randint(5, 123)
                mom = random.choice(moments)
                stkRnd = Stock.select(Stock).where(Stock.magasin == m.mag).order_by(fn.Rand())
                if stkRnd.count() > 0:
                    one_stock = stkRnd.get()
                    nb_items = nb_items + 1
                    it01 = ListeItemModel()
                    it01.liste = ul01.liste
                    it01.mode = ul01.mode
                    it01.etat = EtatListe.Vierge.value
                    it01.reference = one_stock.reference
                    it01.item = "%06d" % j
                    it01.qte_dem = randint(1, 11)
                    it01.qte_serv = 0
                    it01.num_ipp = pat.ipp
                    it01.num_sej = sej.sejour
                    it01.dest = ul01.service
                    it01.moment = mom
                    it01.heure = date_heure_texte(moments_hours[mom])
                    it01.dtprise = current_day.strftime("%Y%m%d")
                    it01.alveole_theo = moments_alveole[mom]
                    it01.type_servi = ul01.type_servi
                    it01.lot = ""
                    it01.info = sej.sejour
                    it01.id_presc = pc01.pk
                    it01.liste_pat = ul01.liste_pat
                    it01.qte_prescrite = it01.qte_dem
                    it01.readonly = item_readonly
                    it01.save()

                    if j in [1, 5, 10, 11, 13, 15, 19]:
                        item_readonly = 1
                    else:
                        item_readonly = 0

            ul01.nb_item = nb_items
            ul01.save()
            current_day = current_day + datetime.timedelta(days=1)


def demo_external_unload(clean=False):
    if clean:
        print("External unload cleanup")
        lsts = ListeModel.select(ListeModel).where(
            ListeModel.mode == TypeListe.Output.value, ListeModel.type_servi == TypeServiListe.ExterneBoite.value
        )
        for li in lsts:
            li.delete_instance()
        return

    current_day = datetime.datetime.now()
    print("Generate datas for Globale")
    mags = Magasin().select(Magasin).where(Magasin.eco_type == "E")
    mags_pick = Magasin().select(Magasin).where(Magasin.eco_type == "C")

    for m in mags:
        print(" -> EXTERNAL %s" % m.mag)
        print("  * Delete previous stock line for %s" % m.mag)
        Stock.delete().where(Stock.magasin == m.mag).execute()
        print("  * Create some stock lines first")
        thresh = Seuil.select(Seuil).where(Seuil.zone == m.type_mag)
        for t in thresh:
            for li in range(5):
                Stock.get_or_create(
                    magasin=m.mag,
                    reference=t.reference,
                    lot="ABCD%s%i" % (time.strftime("%y%m%d"), li),
                    defaults={
                        "adresse": m.mag,
                        "quantite": 10,
                        "date_peremption": date_add_month(datetime.date.today(), 6 + li),
                        "contenant": "%sD%06d" % (time.strftime("%y%m%d"), li + 1),
                        "date_entree": datetime.datetime.now(),
                        "admin": m.type_mag,
                        "fraction": t.fraction,
                    },
                )

        for i in range(5):
            nb_items = 0

            ul01 = ListeModel()
            ul01.liste = "%s-%s-%s" % (m.mag, current_day.strftime("%Y-%m-%d"), "%i" % i)
            ul01.service = "DEENOVA"
            ul01.type_servi = TypeServiListe.ExterneBoite.value
            ul01.mode = TypeListe.Output.value
            ul01.etat = EtatListe.Vierge.value
            ul01.fusion = "EXTERNAL - BOITE"
            ul01.ddeb = current_day
            ul01.zone_deb = m.type_mag
            ul01.zone_fin = mags_pick[0].type_mag
            ul01.num_ipp = PatientGlobal.Ipp.value
            ul01.ipp = PatientGlobal.Ipp.value
            ul01.num_sej = PatientGlobal.Sejour.value
            ul01.no_pilulier = 0
            ul01.selectionne = 0
            ul01.valide_sel = 0
            ul01.pos_pilulier = 0
            ul01.id_prescription = 0
            ul01.username = "FLASK DEMO"
            ul01.liste_pat = "%s-%s-%s" % (m.mag, "GLOBAL", current_day.strftime("%Y%m%d"))
            ul01.save()

            for j in range(1, randint(2, 9)):
                # randint(5, 123)
                # mom = random.choice(moments)
                stkRnd = Stock.select(Stock).where(Stock.magasin == m.mag).order_by(fn.Rand())

                if stkRnd.count() > 0:
                    one_stock = stkRnd.get()
                    nb_items = nb_items + 1
                    it01 = ListeItemModel()
                    it01.liste = ul01.liste
                    it01.mode = ul01.mode
                    it01.etat = EtatListe.Vierge.value
                    it01.reference = one_stock.reference
                    it01.item = "%06d" % j
                    it01.qte_dem = randint(5, 123)
                    it01.qte_serv = 0
                    it01.num_ipp = ul01.num_ipp
                    it01.num_sej = ul01.num_sej
                    it01.dest = ul01.service
                    it01.moment = "matin"
                    it01.heure = 6
                    it01.dtprise = current_day.strftime("%Y%m%d")
                    it01.alveole_theo = 1
                    it01.type_servi = ul01.type_servi
                    it01.lot = ""
                    it01.info = ""
                    it01.id_presc = 0
                    it01.liste_pat = ul01.liste_pat
                    it01.qte_prescrite = it01.qte_dem
                    it01.readonly = 0
                    it01.save()

            ul01.nb_item = nb_items
            ul01.save()
