from peewee import (
    AutoField,
    CharField,
    DateTimeField,
    TextField,
)
from peewee import SQL
from ..base import WebModel


class WebLogActions(WebModel):

    pk = AutoField(
        column_name='id', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    username = CharField(
        column_name='x_user', max_length=20)
    equipement_type = CharField(
        column_name='x_equip_type', max_length=12)
    action = CharField(
        column_name='x_action', max_length=16)
    message = TextField(
        column_name='x_message', default='')

    class Meta:
        table_name = 'web_log_actions'
        indexes = (
            (('x_chrono',), False),
            (('x_equip_type',), False),
            (('x_equip_type', 'x_action'), False),
        )
