from peewee import (
    AutoField,
    CharField,
    IntegerField,
)
from peewee import SQL
from ..base import WebModel


class WebMenu(WebModel):

    pk = AutoField(
        column_name='id', primary_key=True)
    name = CharField(
        column_name='name', max_length=100)
    code = CharField(
        column_name='code', max_length=50)
    icon = CharField(
        column_name='icon', max_length=20, null=True)
    parent = IntegerField(
        column_name='parent_id', null=True)
    sequence = IntegerField(
        column_name='seq_order', null=True, constraints=[SQL("DEFAULT 10")])
    url = CharField(
        column_name='url', max_length=32, null=True)
    anchor = CharField(
        column_name='anchor', max_length=50, null=True)

    class Meta:
        table_name = 'web_menu'
        indexes = (
            (('code',), True),
            (('name',), False),
        )
        constraints = [
            SQL('FOREIGN KEY(parent_id) REFERENCES web_menu(id) ON DELETE CASCADE ON UPDATE CASCADE'),
        ]


class WebMenuTranslation(WebModel):

    pk = AutoField(
        column_name='id', primary_key=True)
    menu_id = IntegerField(
        column_name='menu_id')
    lang_id = IntegerField(
        column_name='lang_id')
    tr_name = CharField(
        column_name='tr_name', max_length=64)

    class Meta:
        table_name = 'web_menu_i18n'
        indexes = (
            (('menu_id', 'lang_id'), True),
        )
        # TODO: Use on delete cascade
        constraints = [
            SQL('FOREIGN KEY(menu_id) REFERENCES web_menu(id) ON DELETE CASCADE ON UPDATE CASCADE'),
            SQL('FOREIGN KEY(lang_id) REFERENCES web_lang(id) ON DELETE CASCADE ON UPDATE CASCADE'),
        ]
