from peewee import (
    AutoField,
    CharField,
    DateTimeField,
    IntegerField, BooleanField,
)
from peewee import SQL

from ..base import WebModel


class WebThresholdParameter(WebModel):
    pk = AutoField(
        column_name='pk', primary_key=True, index=True)
    equipment_pk = IntegerField(column_name='x_equipment_pk', index=True)
    day_threshold_min = IntegerField(column_name='x_day_threshold_min', default=7)
    day_threshold_max = IntegerField(column_name='x_day_threshold_max', default=12)
    loading_pass_threshold = BooleanField(column_name='x_loading_pass_threshold', default=True)
    consuption_min = IntegerField(column_name='x_consuption_min', default=1)
    consuption_max = IntegerField(column_name='x_consuption_max', default=100000)
    patient_number = IntegerField(column_name='x_patient_number', null=True)

    class Meta:
        table_name = 'web_threshold_parameter'


class WebThresholdSheet(WebModel):
    pk = AutoField(
        column_name='pk', primary_key=True, index=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    equipment_pk = IntegerField(column_name='x_equipment_pk')
    reference = CharField(column_name='x_reference', null=True, constraints=[SQL("DEFAULT ''")])
    fraction = IntegerField(column_name='x_fraction', null=True)
    ucd = CharField(column_name='x_ucd', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    threshold_min = IntegerField(column_name='x_threshold_min', null=True)
    threshold_max = IntegerField(column_name='x_threshold_max', null=True)
    threshold_min_calc = IntegerField(column_name='x_threshold_min_calc', null=True)
    threshold_max_calc = IntegerField(column_name='x_threshold_max_calc', null=True)
    threshold_min_user = IntegerField(column_name='x_threshold_min_user', null=True)
    threshold_max_user = IntegerField(column_name='x_threshold_max_user', null=True)
    annual_consumption_calc = IntegerField(column_name='x_annual_consumption_calc', null=True)
    annual_consumption = IntegerField(column_name='x_annual_consumption', null=True)
    cip_blister = IntegerField(column_name='x_cip_blister', null=True)
    cip_pass = IntegerField(column_name='x_cip_pass', null=True)
    cip_box = IntegerField(column_name='x_cip_box', null=True)
    facing_number = IntegerField(column_name='x_facing_number', null=True)
    facing_number_calc = IntegerField(column_name='x_facing_number_calc', null=True)
    replenish_delay = IntegerField(column_name='x_replenish_delay', null=True)
    replenish_delay_calc = IntegerField(column_name='x_replenish_delay_calc', null=True)
    pass_after_replenish_calc = IntegerField(column_name='x_pass_after_replenish_calc', null=True)
    pass_number = IntegerField(column_name='x_pass_number', null=True)
    is_closed = BooleanField(column_name='x_is_closed', default=False)
    closing_date = DateTimeField(
        column_name='x_closing_date', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])

    class Meta:
        table_name = 'web_threshold_sheet'
        indexes = (
            (('x_equipment_pk', 'x_is_closed'), False),
        )
