from common.status import HTTP_501_NOT_IMPLEMENTED


class WebResourceException(Exception):
    def __init__(self, message):
        self.message = message


class WebResource:
    """Parse a ressource"""

    def parse_key(self, args, key, default=None):
        """"""
        if key in args:
            return args[key]
        else:
            return default

    def mandatory(self, data, message=""):
        """Return an axception if data is None"""
        if data is None or not data:
            raise WebResourceException(message)
        return data

    def non_zero(self, data, message="Value cannot be None or 0"):
        if data is None:
            raise WebResourceException(message)
        if isinstance(data, str):
            data = int(data)
        if data == 0:
            raise WebResourceException(message)
        return data

    def boolean(self, data):
        if data is None:
            raise WebResourceException("Boolean value cannot be None")
        if not data:
            raise WebResourceException("Boolean value cannot be empty")

        data = data.lower().strip()
        return data == "true" and True or False

    def get(self):
        """GET method"""
        return {"message": "GET method not implemented"}, HTTP_501_NOT_IMPLEMENTED

    def post(sef):
        """POST method"""
        return {"message": "POST method not implemented"}, HTTP_501_NOT_IMPLEMENTED

    def put(sef):
        """PUT method"""
        return {"message": "PUT method not implemented"}, HTTP_501_NOT_IMPLEMENTED

    def patch(sef):
        """PATCH method"""
        return {"message": "PUT method not implemented"}, HTTP_501_NOT_IMPLEMENTED

    def delete(sef):
        """DELETE method"""
        return {"message": "DELETE method not implemented"}, HTTP_501_NOT_IMPLEMENTED
