"""
Descriptive HTTP status codes, for code readability.

See RFC 2616 and RFC 6585.

RFC 2616: http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html
RFC 6585: http://tools.ietf.org/html/rfc6585
"""

# 1xx Informational
HTTP_100_CONTINUE = 100
"""Client should continue with request.
Use when client should continue with request after sending large data."""

HTTP_101_SWITCHING_PROTOCOLS = 101
"""Server is switching protocols according to Upgrade header.
Use when switching to WebSocket or other protocols."""

# 2xx Success
HTTP_200_OK = 200
"""Request successful.
Default success response for GET and POST requests."""

HTTP_201_CREATED = 201
"""Request fulfilled, new resource created.
Use after successful POST request that creates a new resource."""

HTTP_202_ACCEPTED = 202
"""Request accepted for processing but not completed.
Use for async operations that will finish later."""

HTTP_203_NON_AUTHORITATIVE_INFORMATION = 203
"""Response contains modified server data from a third party.
Use when returning transformed data from another source."""

HTTP_204_NO_CONTENT = 204
"""Request fulfilled, nothing follows.
Use after successful DELETE or when no content needs to be returned."""

HTTP_205_RESET_CONTENT = 205
"""Clear browser form data.
Use to tell the client to reset the document view."""

HTTP_206_PARTIAL_CONTENT = 206
"""Partial content follows.
Use for range requests and streaming of large files."""

HTTP_207_MULTI_STATUS = 207
"""Multiple status responses.
Use when operation results in multiple status codes (WebDAV)."""

# 3xx Redirection
HTTP_300_MULTIPLE_CHOICES = 300
"""Multiple options for the resource delivered.
Use when multiple representations of a resource exist."""

HTTP_301_MOVED_PERMANENTLY = 301
"""Requested resource has been permanently moved to new URL.
Use for permanent URL changes, updates SEO."""

HTTP_302_FOUND = 302
"""Resource found elsewhere, temporarily moved.
Use for temporary redirects, preserves original method."""

HTTP_303_SEE_OTHER = 303
"""Response to request can be found under another URI.
Use to redirect after POST/PUT/DELETE to a GET resource."""

HTTP_304_NOT_MODIFIED = 304
"""Resource has not been modified since last requested.
Use with ETag/If-Modified-Since for caching."""

HTTP_305_USE_PROXY = 305
"""Resource only available through proxy."""

HTTP_306_RESERVED = 306
"""No longer used. Reserved for future use."""

HTTP_307_TEMPORARY_REDIRECT = 307
"""Resource temporarily moved to different URI."""

HTTP_308_PERMANENT_REDIRECT = 308
"""Resource permanently moved to different URI."""

# 4xx Client Error
HTTP_400_BAD_REQUEST = 400
"""Bad request syntax or unsupported method.
Use when request cannot be processed due to client error."""

HTTP_401_UNAUTHORIZED = 401
"""Authentication is required and has failed.
Use when authentication is required but not provided."""

HTTP_402_PAYMENT_REQUIRED = 402
"""Payment is required for resource.
Use for subscription-based or paid APIs."""

HTTP_403_FORBIDDEN = 403
"""Server refuses to authorize request.
Use when authenticated user lacks required permissions."""

HTTP_404_NOT_FOUND = 404
"""Resource not found.
Use when requested resource doesn't exist."""

HTTP_405_METHOD_NOT_ALLOWED = 405
"""Request method not supported for given resource.
Use when HTTP method is not supported (e.g., POST to read-only resource)."""

HTTP_406_NOT_ACCEPTABLE = 406
"""Resource can't generate response meeting accept headers."""

HTTP_407_PROXY_AUTHENTICATION_REQUIRED = 407
"""Proxy authentication required."""

HTTP_408_REQUEST_TIMEOUT = 408
"""Server timed out waiting for the request."""

HTTP_409_CONFLICT = 409
"""Request conflicts with the current state of the server."""

HTTP_410_GONE = 410
"""Resource is no longer available."""

HTTP_411_LENGTH_REQUIRED = 411
"""Request must specify Content-Length."""

HTTP_412_PRECONDITION_FAILED = 412
"""Precondition in headers is false."""

HTTP_413_REQUEST_ENTITY_TOO_LARGE = 413
"""Request entity is too large."""

HTTP_414_REQUEST_URI_TOO_LONG = 414
"""Request URI is too long."""

HTTP_415_UNSUPPORTED_MEDIA_TYPE = 415
"""Unsupported media type."""

HTTP_416_REQUESTED_RANGE_NOT_SATISFIABLE = 416
"""Request range not satisfiable."""

HTTP_417_EXPECTATION_FAILED = 417
"""Server cannot meet request expectations."""

HTTP_418_IM_A_TEAPOT = 418
"""I'm a teapot (RFC 2324)."""

HTTP_422_UNPROCESSABLE_ENTITY = 422
"""Request well-formed but has semantic errors.
Use when validation fails on a syntactically correct request (e.g., invalid field values)."""

HTTP_428_PRECONDITION_REQUIRED = 428
"""The origin server requires the request to be conditional."""

HTTP_429_TOO_MANY_REQUESTS = 429
"""Too many requests in a given time period."""

HTTP_431_REQUEST_HEADER_FIELDS_TOO_LARGE = 431
"""Header fields too large."""

HTTP_444_CONNECTION_CLOSED_WITHOUT_RESPONSE = 444
"""Connection closed without response."""

# 5xx Server Error
HTTP_500_INTERNAL_SERVER_ERROR = 500
"""Server got itself in trouble, general error message.
Use for unhandled exceptions and server-side errors."""

HTTP_501_NOT_IMPLEMENTED = 501
"""Server does not support this operation.
Use when requested functionality is not implemented."""

HTTP_502_BAD_GATEWAY = 502
"""Invalid responses from another server/proxy.
Use when acting as gateway and upstream server fails."""

HTTP_503_SERVICE_UNAVAILABLE = 503
"""Service temporarily overloaded.
Use during maintenance or when system is overloaded."""

HTTP_504_GATEWAY_TIMEOUT = 504
"""Gateway did not receive response from upstream server.
Use when acting as gateway and upstream server times out."""

HTTP_505_HTTP_VERSION_NOT_SUPPORTED = 505
"""HTTP version not supported."""

HTTP_508_LOOP_DETECTED = 508
"""Server detected an infinite loop."""

HTTP_510_NOT_EXTENDED = 510
"""Further extensions needed."""

HTTP_511_NETWORK_AUTHENTICATION_REQUIRED = 511
"""Network authentication required."""
