import logging

from flask import Blueprint

from common.status import HTTP_200_OK, HTTP_400_BAD_REQUEST
from flask_jwt_extended import jwt_required

from median.models.peigne import Peigne

ward_blueprint = Blueprint('ward', __name__)

logger = logging.getLogger('median')


@ward_blueprint.route('typepeigne', methods=['GET'])
@jwt_required()
def get_type_peigne():
    try:

        req = Peigne.select(
            Peigne.libelle,
            Peigne.type_peigne, Peigne.nb_pilulier, Peigne.alveole, Peigne.pk).order_by(Peigne.type_peigne.asc())

        list = []
        for peigne in req:
            obj = {
                "label": peigne.libelle,
                "type": peigne.type_peigne,
                "nbPilulier": peigne.nb_pilulier,
                "alveole": peigne.alveole,
                "pk": peigne.pk
            }
            list.append(obj)

        return {"data": list}, HTTP_200_OK

    except Exception as error:
        logger.error(error.args)
        return {'message': error.args}, HTTP_400_BAD_REQUEST
