import json
import operator
from functools import reduce

from flask import request
from median.models import Patient, Product, HistoriqueMultidoses, Service, HistoriquePrise
from peewee import fn, JOIN


def multidoses_request():
    data = json.loads(request.data)
    criterias = data.get('criterias', [])

    expr = True
    if len(criterias) > 0:
        lst = list(map(lambda s: (
            (Patient.nom.contains(s.strip())) |
            (Patient.prenom.contains(s.strip())) |
            (Product.reference.contains(s.strip())) |
            (Product.designation.contains(s.strip())) |
            (HistoriqueMultidoses.sejour.contains(s.strip())) |
            (HistoriqueMultidoses.ipp.contains(s.strip())) |
            (Service.libelle.contains(s.strip()))
        ), criterias))
        search = reduce(operator.and_, lst)
        expr = reduce(operator.and_, [search])

    sub_qte_asked = (HistoriquePrise.select(HistoriquePrise.reference.alias('reference'),
                                            HistoriquePrise.ipp.alias('ipp'),
                                            HistoriquePrise.sejour.alias('stay'),
                                            HistoriquePrise.service.alias('ward'),
                                            fn.MAX(HistoriquePrise.pk).alias('pk'))
                     .where(
        (HistoriquePrise.info != ''))
                     .group_by(HistoriquePrise.reference,
                               HistoriquePrise.sejour, HistoriquePrise.service)).alias('sub_qte_asked')

    return (HistoriqueMultidoses
            .select(HistoriqueMultidoses.ipp.alias('ipp'),
                    fn.IFNULL(HistoriquePrise.quantite_demande, 0).alias('qty_asked'),
                    HistoriqueMultidoses.quantite_servi.alias('qty_served'),
                    Patient.nom.alias('firstname'),
                    Patient.prenom.alias('lastname'),
                    Product.reference.alias('reference'),
                    Product.designation.alias('product_label'),
                    HistoriqueMultidoses.service.alias('ward_code'),
                    Service.libelle.alias('ward_label'),
                    HistoriqueMultidoses.sejour.alias('stay'),
                    HistoriqueMultidoses.delai_peremption.alias('expiration_delay'),
                    HistoriqueMultidoses.coef_conversion.alias('coef_conv'),
                    HistoriqueMultidoses.unite_gestion.alias('manag_unit'),
                    HistoriqueMultidoses.unite_administration.alias('admin_unit'),
                    HistoriqueMultidoses.date_prise.alias('date'),
                    HistoriqueMultidoses.pk.alias('pk'))
            .join(Product, on=Product.reference == HistoriqueMultidoses.reference)
            .join(Patient, JOIN.LEFT_OUTER, on=Patient.ipp == HistoriqueMultidoses.ipp)
            .join(Service, JOIN.LEFT_OUTER, on=Service.code == HistoriqueMultidoses.service)
            .join(sub_qte_asked, JOIN.LEFT_OUTER,
                  on=(sub_qte_asked.c.reference == HistoriqueMultidoses.reference) &
                     (sub_qte_asked.c.ipp == HistoriqueMultidoses.ipp) &
                     (sub_qte_asked.c.ward == HistoriqueMultidoses.service) &
                     (sub_qte_asked.c.stay == HistoriqueMultidoses.sejour)
                  )
            .join(HistoriquePrise, JOIN.LEFT_OUTER, on=sub_qte_asked.c.pk == HistoriquePrise.pk)
            .where(expr)
            .order_by(HistoriqueMultidoses.date_prise.desc(),
                      HistoriqueMultidoses.service,
                      Patient.nom, Patient.prenom)).objects()
