from common.dto import Dto


class MultiDoseDto(Dto):
    def __init__(self,
                 ipp, first_name, last_name,
                 ward_code, ward_label,
                 product_reference, product_label,
                 qty: int, qty_served: int, coef_conv,
                 manag_unit, admin_unit, expiration_delay,
                 date, stay_num, pk):
        self.ipp = ipp
        self.first_name = first_name
        self.last_name = last_name
        self.ward = ItemDto(code=ward_code, label=ward_label)
        self.product = ItemDto(code=product_reference, label=product_label)
        self.qty = qty
        self.qty_served = qty_served
        self.coef_conv = coef_conv
        self.manag_unit = manag_unit
        self.admin_unit = admin_unit
        self.expiration_delay = expiration_delay
        self.date = str(date.astimezone()) if date is not None else ''
        self.stay_num = stay_num
        self.pk = pk


class ItemDto(Dto):
    def __init__(self, code, label):
        self.code = code
        self.label = label
