import json
import os
import uuid

from flask import Blueprint, request, session
from flask_jwt_extended import jwt_required
from median.database import crypte

from median.models import User

from common.status import HTTP_204_NO_CONTENT, HTTP_200_OK, HTTP_202_ACCEPTED, HTTP_400_BAD_REQUEST
from peewee import DoesNotExist

account_blueprint = Blueprint('account', __name__)

img_folder = os.environ.get('IMAGE_FOLDER', '.')


@account_blueprint.route('/pin', methods=['POST'])
@jwt_required()
def update_pin_code():
    password = request.form['password']
    confirm = request.form['password_confirmation']

    if password == confirm:
        user_id = session['user_id']
        usr = User.select().where((User.isEnabled == 1) & (User.pk == user_id)).get()
        User.update(
            password=crypte(password)
        ).where(User.pk == usr.pk).execute()

        return {}, HTTP_202_ACCEPTED
    else:
        return {'message': 'renewpassword.notequal'}, HTTP_400_BAD_REQUEST


@account_blueprint.route('/info', methods=['PUT'])
@jwt_required()
def update_info():
    # TODO: Refactor this by separating the logic for changing languages
    args = json.loads(request.data)
    v_user = args['name']
    v_email = args['email']
    v_login = args['login']
    v_lang = args['lang']
    v_desc = args['desc']

    calling_usr = User.get(pk=session['user_id'])

    try:
        User.select() \
            .where((User.pk != calling_usr) &
                   (((v_user != '') & (User.username == v_user)) |
                    ((v_email != '') & (User.email == v_email)) |
                    ((v_login != '') & (User.login == v_login)))) \
            .get()
        return {'message': 'User.error.already_exist'}, 500
    except DoesNotExist:

        User.update(
            login=v_login,
            description=v_desc,
            username=v_user, email=v_email,
            lang=v_lang) \
            .where(User.pk == calling_usr).execute()
        return {
            'message': 'Update user %s successfull' % v_user,
        }, HTTP_200_OK


@account_blueprint.route('/avatar', methods=['PUT'])
@jwt_required()
def upload_avatar():
    user = User.get(User.pk == session['user_id'])

    for fname in request.files:
        f = request.files.get(fname)

        file_name = None
        if f.mimetype == 'image/webp':
            file_name = f'{uuid.uuid4()}.webp'
        if f.mimetype == 'image/png':
            file_name = f'{uuid.uuid4()}.png'
        if f.mimetype == 'image/jpeg':
            file_name = f'{uuid.uuid4()}.jpg'

        if file_name is not None:
            url_file = f'{img_folder}\\{user.avatar}'
            if user.avatar is not None and user.avatar != '' and os.path.exists(url_file):
                os.remove(url_file)
            user.avatar = file_name
            user.save()
            f.save(f'{img_folder}\\{file_name}')

        return {'avatar': file_name}, HTTP_200_OK


@account_blueprint.route('/avatar', methods=['DELETE'])
@jwt_required()
def remove_avatar():
    user = User.get(User.pk == session['user_id'])
    file = f'{img_folder}\\{user.avatar}'

    if os.path.exists(file):
        os.remove(file)
    user.avatar = None
    return {}, HTTP_204_NO_CONTENT
