from median.constant import EcoType, EtatAdresse
from median.models import Adresse
from median.constant import PickingMachineType, CuttingMachineType, EquipmentType
from ressources.equipments.store_utils import init_equipment, getColumns_version, add_poste_espace, remove_equipment
from ressources.equipments.store_utils import create_equipment_topo


def generate_aide(data):
    type = data['type']
    version = data['version']
    equipment = None
    versions = [
        PickingMachineType.Aide_Pick.value,
        CuttingMachineType.Aide_Cut.value,
        PickingMachineType.Aide_V2.value
        ]
    if type == EquipmentType.AIDE.value and (version in versions):

        columns_version = getColumns_version(data['version'])

        depths = int(data.get('PROFONDEUR', 2))

        equipment = init_equipment(data)
        equipment.eco_type = (EcoType.Coupe.value
                              if version == CuttingMachineType.Aide_Cut.value
                              else EcoType.Cueillette.value)
        equipment.nb_dim = 3
        equipment.lib_2 = 'EMPLACEMENT'
        equipment.dim_2 = 0
        equipment.lib_3 = 'PROFONDEUR'
        equipment.dim_3 = depths
        equipment.save()

        create_equipment_topo(equipment=equipment, numversion=version)

        try:
            for column in columns_version:
                unit_stock = column.catalogunitstock
                for line in range(column.cataloglines.start_line, column.cataloglines.end_line + 1):
                    for col in range(column.catalogcolumns.start_column, column.catalogcolumns.end_Column + 1):

                        if version == PickingMachineType.Aide_V2.value:
                            offset = (unit_stock.order * unit_stock.total_line * unit_stock.total_colonne)
                            location = offset + line * unit_stock.total_colonne + (col + 1)
                            for d in range(depths):
                                depth = '1' if d == 0 else '3'
                                add_aide_adresse(equipment=equipment,
                                                 address_label=f'{equipment.mag}'
                                                               f'.{"{: >3}".format("BP")}'
                                                               f'.{"{: >3}".format(str(location))}'
                                                               f'.{"{: >3}".format(str(depth))}',
                                                 container_type=column.catalogcolumns.container_type)

                        elif version == CuttingMachineType.Aide_Cut.value:
                            add_aide_adresse(equipment=equipment,
                                             address_label=f'{equipment.mag}'
                                                           f'.{"{: >3}".format("BP")}'
                                                           f'.{"{: >3}".format(str(col + 1))}'
                                                           f'.{"{: >3}".format(str(line + 1))}',
                                             container_type=column.catalogcolumns.container_type)
                        elif version == PickingMachineType.Aide_Pick.value:
                            prefix = 'BP' if column.catalogcolumns.container_type == 'BOITE PASS' else 'TIR'
                            if unit_stock.order < 9:
                                idx = 1
                                offset = unit_stock.total_colonne * unit_stock.order
                            else:
                                idx = 2
                                offset = unit_stock.total_colonne * (unit_stock.order - 9)
                            add_aide_adresse(equipment=equipment,
                                             address_label=f'{equipment.mag}.'
                                                           f'{"{: >3}".format(prefix)}.'
                                                           f'{"{: >3}".format(str(idx))}.'
                                                           f'{"{: >3}".format(str(offset + col + 1))}.'
                                                           f'{"{: >3}".format(str(line + 1))}',
                                             container_type='BOITE PASS')
            add_poste_espace(equipment)

        except Exception as ex:
            remove_equipment(equipment)
            raise Exception(ex.args)

    return equipment


def add_aide_adresse(equipment, container_type, address_label):
    address = Adresse()
    address.adresse = address_label
    address.magasin = equipment.mag
    address.etat = EtatAdresse.Libre.value
    address.nb_div = 1
    address.dim_x = 1
    address.dim_y = 1
    address.princ = 1
    address.format = container_type
    address.save()
