import logging
from median.constant import EcoType
from median.views import GeneratorView

logger = logging.getLogger("median.equip.astus")


def topo_astus(unit_stock, column, line, col, sub_version):
    adresses = []
    v = str(chr(line + ord('A')))
    if column.container_type.startswith('BAC'):
        for d in range(2 if sub_version != 'XL' else 1):
            offset = unit_stock.total_colonne * unit_stock.order
            adresses.append(
                f'{"{: >3}".format(v)}.'
                f'{"{: >3}".format(str(offset + col + 1))}.'
                f'{"{: >3}".format(str(d + 1))}')

    return adresses


def generate_astus(data):
    """
    Generate an astus base on GenertorView
    """
    # type = data["type"]
    Version: str = data["version"]
    SubVersion: str = data["subVersion"]
    Poste: str = data["type_mag"]
    Label: str = data["libelle"]
    IdRobot: str = data["id_robot"]
    IdZone: str = data["id_zone"]

    gen = GeneratorView(data["mag"], EcoType.Astus.value)
    if Version == "ASTUS_V3":
        if SubVersion == "6":
            gen.astus_add_v6(Poste, Label, IdRobot, IdZone)
        elif SubVersion == "7":
            gen.astus_add_v7(Poste, Label, IdRobot, IdZone)
        elif SubVersion == "8":
            gen.astus_add_v8(Poste, Label, IdRobot, IdZone)
        elif SubVersion == "9":
            gen.astus_add_v9(Poste, Label, IdRobot, IdZone)
        elif SubVersion == "10":
            gen.astus_add_v10(Poste, Label, IdRobot, IdZone)
        elif SubVersion == "11":
            gen.astus_add_v11(Poste, Label, IdRobot, IdZone)
        elif SubVersion == "XL":
            gen.astus_add_xl(Poste, Label, IdRobot, IdZone)

    return gen.warehouse
