import logging

from flask import Blueprint
from flask_jwt_extended import jwt_required
from common.status import HTTP_200_OK
from common.util import mustHaveRights
from median.models import Magasin

tools_interfaces = Blueprint("tools_interfaces", __name__)

logger = logging.getLogger("tools.interfaces")

RESSOURCE_NAME = "WEB_ADMINISTRATION"


@tools_interfaces.route("acced-list", methods=["GET"])
@jwt_required()
@mustHaveRights(RESSOURCE_NAME, canView=True)
def get_acced_list():
    """Return the list of ACCED, AIDE-Pick, AIDE-Cut"""
    list_acced = Magasin.select(
        Magasin
    ).where(
        (Magasin.eco_type == 'C') | (Magasin.eco_type == 'T')
    ).order_by(Magasin.type_mag)

    return [{
        "pk": m.pk,
        "code": m.mag,
        "poste": m.type_mag,
        "label": m.libelle,
        "eco_type": m.eco_type,
        "id_zone": m.id_zone,
        "id_robot": m.id_robot,
        "type_dpm": m.type_dpm,
        "type_machine": m.type_machine,
        "groupe": m.groupe
    } for m in list_acced], HTTP_200_OK
